#include "stdafx.h"
#include "queue.h"
#include <winbase.h>

charelement::charelement(char *s, int len, LPTHREAD_START_ROUTINE cb, charelement* n)
{
	char* tmp=new char[len+1];
	for(int i=0; i<len; i++) {
		tmp[i]=s[i];
	}
	tmp[len]=NULL;
	contents=tmp;
	next=n;
	call_back=cb;
	length=len;
}

charelement::~charelement()
{
	delete [] contents;
	if(next!=NULL) {
		delete next;
	}
}

charqueue::charqueue(LPCTSTR name)
{
	length=0;
	head_ptr=NULL;
	last_ptr=NULL;
	//mutex=new CCriticalSection();
	mutex=new CRITICAL_SECTION();
	InitializeCriticalSection(mutex);
	handle=CreateEvent(NULL,TRUE,FALSE,name);
}

charqueue::~charqueue()
{
	delete head_ptr;
}

bool charqueue::pop(charelement*& head)
{
	bool retval;
	Lock();
	if(!empty()) {
		length--;
		charelement *nexthead=head_ptr->next;
		head_ptr->next=NULL;
		head=head_ptr;
		head_ptr=nexthead;
		retval=true;
	} else {
		head=NULL;
		retval=false;
	}
	Unlock();
	return retval;
} 
void charqueue::push2(char* s, int len, LPTHREAD_START_ROUTINE cb)
{
	Lock();
	charelement *tmp=new charelement(s,len,cb,NULL);
	if(empty()) {
		head_ptr=tmp;
		last_ptr=head_ptr;
		length++;
	} else {
		last_ptr->next=tmp;
		last_ptr=tmp;
		length++;
	}
	Unlock();
	PulseEvent(handle);
}

void charqueue::push(char* s, LPTHREAD_START_ROUTINE cb)
{
	push2(s,strlen(s),cb);
}